﻿'版权所有 (C) Microsoft Corporation。保留所有权利。

Imports System
Imports System.Collections
Imports System.Collections.Generic
Imports System.IO
Imports System.Windows.Forms
Imports System.Linq
Imports System.Data.Linq.Mapping
Imports nwind
Imports System.Data.SqlClient

Namespace Samples

    Class Program

        Shared Sub Main()

            ' 编写以下代码时假定:
            ' 1. 计算机中已安装了 SQL Server 2005 Express
            ' 2. 安装含有 Northwind 的 Data Sample 目录。
            ' 或者，如果已安装 Northwind，则需要将连接字符串改为
            ' Northwind db = new Northwind("Server=.\\SQLExpress;Database=Northwind;Trusted_Connection=True");
            ' 必须编辑路径，使其指向计算机中的 mdf 文件
            ' Northwind db = new Northwind("c:\\northwind\\northwnd.mdf");

            Dim dbPath As String = System.IO.Path.GetFullPath(System.IO.Path.Combine(Application.StartupPath, "..\..\Data\NORTHWIND.MDF"))
            Dim sqlServerInstance As String = ".\SQLEXPRESS"
            Dim connString As String = "AttachDBFileName='" + dbPath + "';Server='" + sqlServerInstance + "';user instance=true;Integrated Security=SSPI;"

            Dim path As String = System.IO.Path.GetFullPath(System.IO.Path.Combine(Application.StartupPath, "..\..\Northwind.xml"))

            Dim mappingSource As XmlMappingSource = XmlMappingSource.FromXml(File.ReadAllText(path))
            Dim db As Northwind = New Northwind(connString, mappingSource)
            db.Log = Console.Out
            Samples.Sample1(db)
            Console.ReadLine()

        End Sub
    End Class

End Namespace